/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProject;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.ui.internal.server.BaseContentProvider;

public class ServerContentProvider
extends BaseContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object element) {
        return ServersManager.getInstance().getServers().toArray();
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IServer) {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            for (SonarLintProject p : ((IServer)element).getBoundProjects()) {
                projects.add(p.getProject());
            }
            return projects.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IProject) {
            String serverId = SonarLintProject.getInstance((IResource)((IProject)element)).getServerId();
            return ServersManager.getInstance().getServer(serverId);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IServer) {
            return !((IServer)element).getBoundProjects().isEmpty();
        }
        return false;
    }
}

